package swing.models;

import swing.common.Demo;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;

public class ListDemo extends Demo {
    private final static ListCellRenderer<Integer> renderer = new ListCellRenderer<Integer>() {
        private final Border selectedBorder = BorderFactory.createLineBorder(Color.BLACK, 1);
        private final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        
        private final JLabel label = new JLabel();

        {
            label.setOpaque(true);
        }

        public JLabel getListCellRendererComponent(
                final JList list, final Integer value,
                final int index, final boolean isSelected, final boolean cellHasFocus
        ) {
            label.setText(value.toString());
            label.setBackground(value < 0 ? Color.RED : Color.WHITE);
            label.setBorder(isSelected ? selectedBorder : normalBorder);
            return label;
        }
    };

    public ListDemo() {
        super("ListDemo");

        add(createMainPanel(), BorderLayout.CENTER);

        pack();
    }

    private Component createMainPanel() {
        final JPanel panel = new JPanel();

        final JList<Integer> list2 = new JList<>(new Integer[]{1, 2, 3, -1, -2, -3, 4});
        list2.setPreferredSize(new Dimension(50, list2.getPreferredSize().height));
        panel.add(list2);

        final JList<Integer> list = new JList<>(new Integer[]{1, 2, 3, -1, -2, -3, 4});
        list.setPreferredSize(new Dimension(50, list.getPreferredSize().height));
        list.setCellRenderer(renderer);
        panel.add(list);

        final JComboBox<Integer> comboBox = new JComboBox<>(new Integer[]{1, 2, 3, -1, -2, -3, 4});
        comboBox.setRenderer(renderer);
        //comboBox.setEditable(true);
        panel.add(comboBox, BorderLayout.LINE_END);

        return panel;
    }

    public static void main(final String[] args) {
        new ListDemo().setVisible(true);
    }
}

