/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.util.Random;

public class BigInteger
extends Number {
    private int signum;
    private byte[] magnitude;
    private int bitCount = -1;
    private int bitLength = -1;
    private int firstNonzeroByteNum = -2;
    private int lowestSetBit = -2;
    private static final BigInteger ZERO = new BigInteger(new byte[0], 0);
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst = new BigInteger[17];
    private static BigInteger[] negConst = new BigInteger[17];
    private static final byte[] bitLen;
    private static final byte[] bitCnt;
    private static final byte[] trailingZeroCnt;
    private static String[] zeros;
    private static final BigInteger ONE;
    private static final BigInteger TWO;
    private static final char ZERO_CHAR;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;
    private static final long serialVersionUID = -8287574255936472291L;

    public BigInteger(byte[] byArray) throws NumberFormatException {
        if (byArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (byArray[0] < 0) {
            this.magnitude = BigInteger.makePositive(byArray);
            this.signum = -1;
            return;
        }
        this.magnitude = BigInteger.stripLeadingZeroBytes(byArray);
        this.signum = this.magnitude.length == 0 ? 0 : 1;
    }

    public BigInteger(int n, byte[] byArray) throws NumberFormatException {
        this.magnitude = BigInteger.stripLeadingZeroBytes(byArray);
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.magnitude.length == 0) {
            this.signum = 0;
            return;
        }
        if (n == 0) {
            throw new NumberFormatException("signum-magnitude mismatch");
        }
        this.signum = n;
    }

    public BigInteger(String string, int n) throws NumberFormatException {
        int n2 = 0;
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.signum = 1;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.signum = -1;
            n2 = 1;
        }
        while (n2 < string.length() && string.charAt(n2) == ZERO_CHAR) {
            ++n2;
        }
        if (n2 == string.length()) {
            this.signum = 0;
            this.magnitude = new byte[0];
            return;
        }
        int n3 = string.length() - n2;
        int n4 = n3 % digitsPerLong[n];
        if (n4 == 0) {
            n4 = digitsPerLong[n];
        }
        String string2 = string.substring(n2, n2 += n4);
        BigInteger bigInteger = BigInteger.valueOf(Long.parseLong(string2, n));
        while (n2 < string.length()) {
            long l;
            if ((l = Long.parseLong(string2 = string.substring(n2, n2 += digitsPerLong[n]), n)) < 0L) {
                throw new NumberFormatException("Illegal digit");
            }
            bigInteger = bigInteger.multiply(longRadix[n]).add(BigInteger.valueOf(l));
        }
        this.magnitude = bigInteger.magnitude;
    }

    public BigInteger(String string) throws NumberFormatException {
        this(string, 10);
    }

    public BigInteger(int n, Random random) throws IllegalArgumentException {
        this(1, BigInteger.randomBits(n, random));
    }

    private static byte[] randomBits(int n, Random random) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            random.nextBytes(byArray);
            int n3 = 8 * n2 - n;
            byArray[0] = (byte)(byArray[0] & (1 << 8 - n3) - 1);
        }
        return byArray;
    }

    public BigInteger(int n, int n2, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (n < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        do {
            bigInteger2 = new BigInteger(n - 1, random).setBit(n - 1);
            if (n <= 16) {
                if (n > 2) {
                    bigInteger = bigInteger2.setBit(0);
                    continue;
                }
                bigInteger = bigInteger2;
                continue;
            }
            bigInteger = new BigInteger(BigInteger.plumbGeneratePrime(bigInteger2.magnitude), 1);
        } while ((bigInteger2 = bigInteger).bitLength() != n || !bigInteger2.isProbablePrime(n2));
        this.signum = 1;
        this.magnitude = bigInteger2.magnitude;
    }

    private BigInteger(byte[] byArray, int n) {
        this.signum = byArray.length == 0 ? 0 : n;
        this.magnitude = byArray;
    }

    public static BigInteger valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l > 0L && l <= 16L) {
            return posConst[(int)l];
        }
        if (l < 0L && l >= -16L) {
            return negConst[(int)(-l)];
        }
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[7 - n] = (byte)l;
            ++n;
            l >>= 8;
        }
        return new BigInteger(byArray);
    }

    private static BigInteger valueOf(byte[] byArray) {
        if (byArray[0] > 0) {
            return new BigInteger(byArray, 1);
        }
        return new BigInteger(byArray);
    }

    public BigInteger add(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return bigInteger;
        }
        if (bigInteger.signum == this.signum) {
            return new BigInteger(BigInteger.plumbAdd(this.magnitude, bigInteger.magnitude), this.signum);
        }
        if (this.signum < 0) {
            return BigInteger.plumbSubtract(bigInteger.magnitude, this.magnitude);
        }
        return BigInteger.plumbSubtract(this.magnitude, bigInteger.magnitude);
    }

    public BigInteger subtract(BigInteger bigInteger) {
        return this.add(new BigInteger(bigInteger.magnitude, -bigInteger.signum));
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (bigInteger.signum == 0 || this.signum == 0) {
            return ZERO;
        }
        return new BigInteger(BigInteger.plumbMultiply(this.magnitude, bigInteger.magnitude), this.signum * bigInteger.signum);
    }

    public BigInteger divide(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.signum == 0) {
            return ZERO;
        }
        return new BigInteger(BigInteger.plumbDivide(this.magnitude, bigInteger.magnitude), this.signum * bigInteger.signum);
    }

    public BigInteger remainder(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.signum == 0) {
            return ZERO;
        }
        if (this.magnitude.length < bigInteger.magnitude.length) {
            return this;
        }
        return new BigInteger(BigInteger.plumbRemainder(this.magnitude, bigInteger.magnitude), this.signum);
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) throws ArithmeticException {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (bigInteger.signum == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        if (this.signum == 0) {
            bigIntegerArray[0] = bigIntegerArray[1] = ZERO;
        } else if (this.magnitude.length < bigInteger.magnitude.length) {
            bigIntegerArray[0] = ZERO;
            bigIntegerArray[1] = this;
        } else {
            byte[][] byArray = BigInteger.plumbDivideAndRemainder(this.magnitude, bigInteger.magnitude);
            bigIntegerArray[0] = new BigInteger(byArray[0], this.signum * bigInteger.signum);
            bigIntegerArray[1] = new BigInteger(byArray[1], this.signum);
        }
        return bigIntegerArray;
    }

    public BigInteger pow(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.signum == 0) {
            if (n == 0) {
                return ONE;
            }
            return this;
        }
        BigInteger bigInteger = BigInteger.valueOf(n < 0 && (n & 1) == 1 ? -1 : 1);
        BigInteger bigInteger2 = this;
        while (n != 0) {
            if ((n & 1) == 1) {
                bigInteger = bigInteger.multiply(bigInteger2);
            }
            if ((n >>= 1) == 0) continue;
            bigInteger2 = new BigInteger(BigInteger.plumbSquare(bigInteger2.magnitude), 1);
        }
        return bigInteger;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (bigInteger.signum == 0) {
            return this.abs();
        }
        if (this.signum == 0) {
            return bigInteger.abs();
        }
        return new BigInteger(BigInteger.plumbGcd(this.magnitude, bigInteger.magnitude), 1);
    }

    public BigInteger abs() {
        if (this.signum >= 0) {
            return this;
        }
        return this.negate();
    }

    public BigInteger negate() {
        return new BigInteger(this.magnitude, -this.signum);
    }

    public int signum() {
        return this.signum;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        if (bigInteger2.signum >= 0) {
            return bigInteger2;
        }
        return bigInteger2.add(bigInteger);
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (bigInteger2.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (bigInteger.signum == 0) {
            return ONE;
        }
        boolean bl = bigInteger.signum < 0;
        if (bl) {
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger5 = bigInteger4 = this.signum < 0 || this.compareTo(bigInteger2) >= 0 ? this.mod(bigInteger2) : this;
        if (bigInteger2.testBit(0)) {
            bigInteger3 = new BigInteger(BigInteger.plumbModPow(bigInteger4.magnitude, bigInteger.magnitude, bigInteger2.magnitude), 1);
        } else {
            int n = bigInteger2.getLowestSetBit();
            BigInteger bigInteger6 = bigInteger2.shiftRight(n);
            BigInteger bigInteger7 = ONE.shiftLeft(n);
            BigInteger bigInteger8 = new BigInteger(BigInteger.plumbModPow(bigInteger4.magnitude, bigInteger.magnitude, bigInteger6.magnitude), 1);
            BigInteger bigInteger9 = bigInteger4.modPow2(bigInteger, n);
            BigInteger bigInteger10 = bigInteger7.modInverse(bigInteger6);
            BigInteger bigInteger11 = bigInteger6.modInverse(bigInteger7);
            bigInteger3 = bigInteger8.multiply(bigInteger7).multiply(bigInteger10).add(bigInteger9.multiply(bigInteger6).multiply(bigInteger11)).mod(bigInteger2);
        }
        if (bl) {
            return bigInteger3.modInverse(bigInteger2);
        }
        return bigInteger3;
    }

    private BigInteger modPow2(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = this.mod2(n);
        while (bigInteger.signum != 0) {
            if (bigInteger.testBit(0)) {
                bigInteger2 = bigInteger2.multiply(bigInteger3).mod2(n);
            }
            bigInteger = bigInteger.shiftRight(1);
            if (bigInteger.signum == 0) continue;
            bigInteger3 = new BigInteger(BigInteger.plumbSquare(bigInteger3.magnitude), 1).mod2(n);
        }
        return bigInteger2;
    }

    private BigInteger mod2(int n) {
        if (this.bitLength() <= n) {
            return this;
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.magnitude[n3 + (this.magnitude.length - n2)];
            ++n3;
        }
        int n4 = 8 * n2 - n;
        byArray[0] = (byte)(byArray[0] & (1 << 8 - n4) - 1);
        if (byArray[0] == 0) {
            return new BigInteger(1, byArray);
        }
        return new BigInteger(byArray, 1);
    }

    public BigInteger modInverse(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.signum != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        if (bigInteger2.signum < 0) {
            bigInteger2 = bigInteger2.add(bigInteger);
        }
        if (!bigInteger2.gcd(bigInteger).equals(ONE)) {
            throw new ArithmeticException("BigInteger not invertible");
        }
        return new BigInteger(BigInteger.plumbModInverse(bigInteger2.magnitude, bigInteger.magnitude), 1);
    }

    public BigInteger shiftLeft(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        int n2 = n / 8;
        int n3 = n % 8;
        byte[] byArray = new byte[(this.bitLength() + n) / 8 + 1];
        if (n3 == 0) {
            int n4 = n2;
            while (n4 < byArray.length) {
                byArray[byArray.length - 1 - n4] = this.getByte(n4 - n2);
                ++n4;
            }
        } else {
            int n5 = n2;
            while (n5 < byArray.length) {
                byArray[byArray.length - 1 - n5] = (byte)(this.getByte(n5 - n2) << n3 | (n5 == n2 ? 0 : (this.getByte(n5 - n2 - 1) & 0xFF) >> 8 - n3));
                ++n5;
            }
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        if (n >= this.bitLength()) {
            if (this.signum < 0) {
                return BigInteger.valueOf(-1L);
            }
            return ZERO;
        }
        int n2 = n / 8;
        int n3 = n % 8;
        byte[] byArray = new byte[(this.bitLength - n) / 8 + 1];
        if (n3 == 0) {
            int n4 = 0;
            while (n4 < byArray.length) {
                byArray[byArray.length - 1 - n4] = this.getByte(n2 + n4);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < byArray.length) {
                byArray[byArray.length - 1 - n5] = (byte)((this.getByte(n2 + n5 + 1) << 8 | this.getByte(n2 + n5) & 0xFF) >> n3);
                ++n5;
            }
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger and(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) & bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger or(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) | bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger xor(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) ^ bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger not() {
        byte[] byArray = new byte[this.byteLength()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = ~this.getByte(byArray.length - n - 1);
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public BigInteger andNot(BigInteger bigInteger) {
        byte[] byArray = new byte[Math.max(this.byteLength(), bigInteger.byteLength())];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(this.getByte(byArray.length - n - 1) & ~bigInteger.getByte(byArray.length - n - 1));
            ++n;
        }
        return BigInteger.valueOf(byArray);
    }

    public boolean testBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.getByte(n / 8) & 1 << n % 8) != 0;
    }

    public BigInteger setBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 8;
        byte[] byArray = new byte[Math.max(this.byteLength(), n2 + 2)];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[byArray.length - n3 - 1] = this.getByte(n3);
            ++n3;
        }
        int n4 = byArray.length - n2 - 1;
        byArray[n4] = (byte)(byArray[n4] | 1 << n % 8);
        return BigInteger.valueOf(byArray);
    }

    public BigInteger clearBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 8;
        byte[] byArray = new byte[Math.max(this.byteLength(), (n + 1) / 8 + 1)];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[byArray.length - n3 - 1] = this.getByte(n3);
            ++n3;
        }
        int n4 = byArray.length - n2 - 1;
        byArray[n4] = (byte)(byArray[n4] & ~(1 << n % 8));
        return BigInteger.valueOf(byArray);
    }

    public BigInteger flipBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n / 8;
        byte[] byArray = new byte[Math.max(this.byteLength(), n2 + 2)];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[byArray.length - n3 - 1] = this.getByte(n3);
            ++n3;
        }
        int n4 = byArray.length - n2 - 1;
        byArray[n4] = (byte)(byArray[n4] ^ 1 << n % 8);
        return BigInteger.valueOf(byArray);
    }

    public int getLowestSetBit() {
        if (this.lowestSetBit == -2) {
            if (this.signum == 0) {
                this.lowestSetBit = -1;
            } else {
                byte by;
                int n = 0;
                while ((by = this.getByte(n)) == 0) {
                    ++n;
                }
                this.lowestSetBit = 8 * n + trailingZeroCnt[by & 0xFF];
            }
        }
        return this.lowestSetBit;
    }

    public int bitLength() {
        if (this.bitLength == -1) {
            if (this.signum == 0) {
                this.bitLength = 0;
            } else {
                int n = 8 * (this.magnitude.length - 1) + bitLen[this.magnitude[0] & 0xFF];
                if (this.signum < 0) {
                    boolean bl = bitCnt[this.magnitude[0] & 0xFF] == 1;
                    int n2 = 1;
                    while (n2 < this.magnitude.length && bl) {
                        bl = this.magnitude[n2] == 0;
                        ++n2;
                    }
                    this.bitLength = bl ? n - 1 : n;
                } else {
                    this.bitLength = n;
                }
            }
        }
        return this.bitLength;
    }

    public int bitCount() {
        if (this.bitCount == -1) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.magnitude.length) {
                n += bitCnt[this.magnitude[n2] & 0xFF];
                ++n2;
            }
            if (this.signum < 0) {
                int n3 = 0;
                int n4 = this.magnitude.length - 1;
                while (this.magnitude[n4] == 0) {
                    n3 += 8;
                    --n4;
                }
                this.bitCount = n + (n3 += trailingZeroCnt[this.magnitude[n4] & 0xFF]) - 1;
            } else {
                this.bitCount = n;
            }
        }
        return this.bitCount;
    }

    public boolean isProbablePrime(int n) {
        int n2 = n / 2;
        if (n2 <= 0) {
            return true;
        }
        BigInteger bigInteger = this.abs();
        if (bigInteger.equals(TWO)) {
            return true;
        }
        if (!bigInteger.testBit(0) || bigInteger.equals(ONE)) {
            return false;
        }
        BigInteger bigInteger2 = bigInteger.subtract(ONE);
        int n3 = bigInteger2.getLowestSetBit();
        bigInteger2 = bigInteger2.shiftRight(n3);
        Random random = new Random();
        int n4 = 0;
        while (n4 < n2) {
            BigInteger bigInteger3;
            while ((bigInteger3 = new BigInteger(bigInteger.bitLength(), random)).compareTo(ONE) <= 0 || bigInteger3.compareTo(bigInteger) >= 0) {
            }
            int n5 = 0;
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
            while (!(n5 == 0 && bigInteger4.equals(ONE) || bigInteger4.equals(bigInteger.subtract(ONE)))) {
                if (n5 > 0 && bigInteger4.equals(ONE) || ++n5 == n3) {
                    return false;
                }
                bigInteger4 = bigInteger4.modPow(TWO, bigInteger);
            }
            ++n4;
        }
        return true;
    }

    public int compareTo(BigInteger bigInteger) {
        if (this.signum == bigInteger.signum) {
            return this.signum * BigInteger.byteArrayCmp(this.magnitude, bigInteger.magnitude);
        }
        if (this.signum > bigInteger.signum) {
            return 1;
        }
        return -1;
    }

    private static int byteArrayCmp(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return -1;
        }
        if (byArray.length > byArray2.length) {
            return 1;
        }
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            int n3 = byArray2[n] & 0xFF;
            if (n2 < n3) {
                return -1;
            }
            if (n2 > n3) {
                return 1;
            }
            ++n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInteger)) {
            return false;
        }
        BigInteger bigInteger = (BigInteger)object;
        if (bigInteger.signum != this.signum || bigInteger.magnitude.length != this.magnitude.length) {
            return false;
        }
        if (bigInteger == this) {
            return true;
        }
        int n = 0;
        while (n < this.magnitude.length) {
            if (bigInteger.magnitude[n] != this.magnitude[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public BigInteger min(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) < 0) {
            return this;
        }
        return bigInteger;
    }

    public BigInteger max(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) > 0) {
            return this;
        }
        return bigInteger;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.magnitude.length) {
            n = 37 * n + (this.magnitude[n2] & 0xFF);
            ++n2;
        }
        return n * this.signum;
    }

    public String toString(int n) {
        Object object;
        if (this.signum == 0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            n = 10;
        }
        int n2 = (this.magnitude.length + 6) / 7;
        String[] stringArray = new String[n2];
        Object object2 = this.abs();
        int n3 = 0;
        while (((BigInteger)object2).signum != 0) {
            object = ((BigInteger)object2).divideAndRemainder(longRadix[n]);
            stringArray[n3++] = Long.toString(object[1].longValue(), n);
            object2 = object[0];
        }
        object = new StringBuffer(n3 * digitsPerLong[n] + 1);
        if (this.signum < 0) {
            ((StringBuffer)object).append('-');
        }
        ((StringBuffer)object).append(stringArray[n3 - 1]);
        int n4 = n3 - 2;
        while (n4 >= 0) {
            int n5 = digitsPerLong[n] - stringArray[n4].length();
            if (n5 != 0) {
                ((StringBuffer)object).append(zeros[n5]);
            }
            ((StringBuffer)object).append(stringArray[n4]);
            --n4;
        }
        return ((StringBuffer)object).toString();
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.byteLength()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.getByte(byArray.length - n - 1);
            ++n;
        }
        return byArray;
    }

    public int intValue() {
        int n = 0;
        int n2 = 3;
        while (n2 >= 0) {
            n = (n << 8) + (this.getByte(n2) & 0xFF);
            --n2;
        }
        return n;
    }

    public long longValue() {
        long l = 0L;
        int n = 7;
        while (n >= 0) {
            l = (l << 8) + (long)(this.getByte(n) & 0xFF);
            --n;
        }
        return l;
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    private static byte[] stripLeadingZeroBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length && byArray[n] == 0) {
            ++n;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        int n2 = n;
        while (n2 < byArray.length) {
            byArray2[n2 - n] = byArray[n2];
            ++n2;
        }
        return byArray2;
    }

    private static byte[] makePositive(byte[] byArray) {
        int n;
        int n2 = 0;
        while (n2 < byArray.length && byArray[n2] == -1) {
            ++n2;
        }
        int n3 = n2;
        while (n3 < byArray.length && byArray[n3] == 0) {
            ++n3;
        }
        int n4 = n3 == byArray.length ? 1 : 0;
        byte[] byArray2 = new byte[byArray.length - n2 + n4];
        int n5 = n2;
        while (n5 < byArray.length) {
            byArray2[n5 - n2 + n4] = ~byArray[n5];
            ++n5;
        }
        int n6 = byArray2.length - 1;
        do {
            n = n6--;
        } while ((byArray2[n] = (byte)(byArray2[n] + 1)) == 0);
        return byArray2;
    }

    private int byteLength() {
        return this.bitLength() / 8 + 1;
    }

    private int signBit() {
        if (this.signum < 0) {
            return 1;
        }
        return 0;
    }

    private byte signByte() {
        return (byte)(this.signum < 0 ? -1 : 0);
    }

    private byte getByte(int n) {
        if (n >= this.magnitude.length) {
            return this.signByte();
        }
        int n2 = this.magnitude[this.magnitude.length - n - 1];
        return (byte)(this.signum >= 0 ? n2 : (n <= this.firstNonzeroByteNum() ? -n2 : ~n2));
    }

    private int firstNonzeroByteNum() {
        if (this.firstNonzeroByteNum == -2) {
            int n = this.magnitude.length - 1;
            while (n >= 0 && this.magnitude[n] == 0) {
                --n;
            }
            this.firstNonzeroByteNum = this.magnitude.length - n - 1;
        }
        return this.firstNonzeroByteNum;
    }

    private static native void plumbInit();

    private static native byte[] plumbAdd(byte[] var0, byte[] var1);

    private static native BigInteger plumbSubtract(byte[] var0, byte[] var1);

    private static native byte[] plumbMultiply(byte[] var0, byte[] var1);

    private static native byte[] plumbDivide(byte[] var0, byte[] var1);

    private static native byte[] plumbRemainder(byte[] var0, byte[] var1);

    private static native byte[][] plumbDivideAndRemainder(byte[] var0, byte[] var1);

    private static native byte[] plumbGcd(byte[] var0, byte[] var1);

    private static native byte[] plumbModPow(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] plumbModInverse(byte[] var0, byte[] var1);

    private static native byte[] plumbSquare(byte[] var0);

    private static native byte[] plumbGeneratePrime(byte[] var0);

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.magnitude = (byte[])this.magnitude.clone();
        if (this.signum < -1 || this.signum > 1) {
            throw new StreamCorruptedException("BigInteger: Invalid signum value");
        }
        if (this.magnitude.length == 0 != (this.signum == 0)) {
            throw new StreamCorruptedException("BigInteger: signum-magnitude mismatch");
        }
        this.bitLength = -1;
        this.bitCount = -1;
        this.firstNonzeroByteNum = -2;
        this.lowestSetBit = -2;
    }

    static {
        int n = 1;
        while (n <= 16) {
            byte[] byArray = new byte[]{(byte)n};
            BigInteger.posConst[n] = new BigInteger(byArray, 1);
            BigInteger.negConst[n] = new BigInteger(byArray, -1);
            ++n;
        }
        byte[] byArray = new byte[256];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 2;
        byArray[4] = 3;
        byArray[5] = 3;
        byArray[6] = 3;
        byArray[7] = 3;
        byArray[8] = 4;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[13] = 4;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 5;
        byArray[17] = 5;
        byArray[18] = 5;
        byArray[19] = 5;
        byArray[20] = 5;
        byArray[21] = 5;
        byArray[22] = 5;
        byArray[23] = 5;
        byArray[24] = 5;
        byArray[25] = 5;
        byArray[26] = 5;
        byArray[27] = 5;
        byArray[28] = 5;
        byArray[29] = 5;
        byArray[30] = 5;
        byArray[31] = 5;
        byArray[32] = 6;
        byArray[33] = 6;
        byArray[34] = 6;
        byArray[35] = 6;
        byArray[36] = 6;
        byArray[37] = 6;
        byArray[38] = 6;
        byArray[39] = 6;
        byArray[40] = 6;
        byArray[41] = 6;
        byArray[42] = 6;
        byArray[43] = 6;
        byArray[44] = 6;
        byArray[45] = 6;
        byArray[46] = 6;
        byArray[47] = 6;
        byArray[48] = 6;
        byArray[49] = 6;
        byArray[50] = 6;
        byArray[51] = 6;
        byArray[52] = 6;
        byArray[53] = 6;
        byArray[54] = 6;
        byArray[55] = 6;
        byArray[56] = 6;
        byArray[57] = 6;
        byArray[58] = 6;
        byArray[59] = 6;
        byArray[60] = 6;
        byArray[61] = 6;
        byArray[62] = 6;
        byArray[63] = 6;
        byArray[64] = 7;
        byArray[65] = 7;
        byArray[66] = 7;
        byArray[67] = 7;
        byArray[68] = 7;
        byArray[69] = 7;
        byArray[70] = 7;
        byArray[71] = 7;
        byArray[72] = 7;
        byArray[73] = 7;
        byArray[74] = 7;
        byArray[75] = 7;
        byArray[76] = 7;
        byArray[77] = 7;
        byArray[78] = 7;
        byArray[79] = 7;
        byArray[80] = 7;
        byArray[81] = 7;
        byArray[82] = 7;
        byArray[83] = 7;
        byArray[84] = 7;
        byArray[85] = 7;
        byArray[86] = 7;
        byArray[87] = 7;
        byArray[88] = 7;
        byArray[89] = 7;
        byArray[90] = 7;
        byArray[91] = 7;
        byArray[92] = 7;
        byArray[93] = 7;
        byArray[94] = 7;
        byArray[95] = 7;
        byArray[96] = 7;
        byArray[97] = 7;
        byArray[98] = 7;
        byArray[99] = 7;
        byArray[100] = 7;
        byArray[101] = 7;
        byArray[102] = 7;
        byArray[103] = 7;
        byArray[104] = 7;
        byArray[105] = 7;
        byArray[106] = 7;
        byArray[107] = 7;
        byArray[108] = 7;
        byArray[109] = 7;
        byArray[110] = 7;
        byArray[111] = 7;
        byArray[112] = 7;
        byArray[113] = 7;
        byArray[114] = 7;
        byArray[115] = 7;
        byArray[116] = 7;
        byArray[117] = 7;
        byArray[118] = 7;
        byArray[119] = 7;
        byArray[120] = 7;
        byArray[121] = 7;
        byArray[122] = 7;
        byArray[123] = 7;
        byArray[124] = 7;
        byArray[125] = 7;
        byArray[126] = 7;
        byArray[127] = 7;
        byArray[128] = 8;
        byArray[129] = 8;
        byArray[130] = 8;
        byArray[131] = 8;
        byArray[132] = 8;
        byArray[133] = 8;
        byArray[134] = 8;
        byArray[135] = 8;
        byArray[136] = 8;
        byArray[137] = 8;
        byArray[138] = 8;
        byArray[139] = 8;
        byArray[140] = 8;
        byArray[141] = 8;
        byArray[142] = 8;
        byArray[143] = 8;
        byArray[144] = 8;
        byArray[145] = 8;
        byArray[146] = 8;
        byArray[147] = 8;
        byArray[148] = 8;
        byArray[149] = 8;
        byArray[150] = 8;
        byArray[151] = 8;
        byArray[152] = 8;
        byArray[153] = 8;
        byArray[154] = 8;
        byArray[155] = 8;
        byArray[156] = 8;
        byArray[157] = 8;
        byArray[158] = 8;
        byArray[159] = 8;
        byArray[160] = 8;
        byArray[161] = 8;
        byArray[162] = 8;
        byArray[163] = 8;
        byArray[164] = 8;
        byArray[165] = 8;
        byArray[166] = 8;
        byArray[167] = 8;
        byArray[168] = 8;
        byArray[169] = 8;
        byArray[170] = 8;
        byArray[171] = 8;
        byArray[172] = 8;
        byArray[173] = 8;
        byArray[174] = 8;
        byArray[175] = 8;
        byArray[176] = 8;
        byArray[177] = 8;
        byArray[178] = 8;
        byArray[179] = 8;
        byArray[180] = 8;
        byArray[181] = 8;
        byArray[182] = 8;
        byArray[183] = 8;
        byArray[184] = 8;
        byArray[185] = 8;
        byArray[186] = 8;
        byArray[187] = 8;
        byArray[188] = 8;
        byArray[189] = 8;
        byArray[190] = 8;
        byArray[191] = 8;
        byArray[192] = 8;
        byArray[193] = 8;
        byArray[194] = 8;
        byArray[195] = 8;
        byArray[196] = 8;
        byArray[197] = 8;
        byArray[198] = 8;
        byArray[199] = 8;
        byArray[200] = 8;
        byArray[201] = 8;
        byArray[202] = 8;
        byArray[203] = 8;
        byArray[204] = 8;
        byArray[205] = 8;
        byArray[206] = 8;
        byArray[207] = 8;
        byArray[208] = 8;
        byArray[209] = 8;
        byArray[210] = 8;
        byArray[211] = 8;
        byArray[212] = 8;
        byArray[213] = 8;
        byArray[214] = 8;
        byArray[215] = 8;
        byArray[216] = 8;
        byArray[217] = 8;
        byArray[218] = 8;
        byArray[219] = 8;
        byArray[220] = 8;
        byArray[221] = 8;
        byArray[222] = 8;
        byArray[223] = 8;
        byArray[224] = 8;
        byArray[225] = 8;
        byArray[226] = 8;
        byArray[227] = 8;
        byArray[228] = 8;
        byArray[229] = 8;
        byArray[230] = 8;
        byArray[231] = 8;
        byArray[232] = 8;
        byArray[233] = 8;
        byArray[234] = 8;
        byArray[235] = 8;
        byArray[236] = 8;
        byArray[237] = 8;
        byArray[238] = 8;
        byArray[239] = 8;
        byArray[240] = 8;
        byArray[241] = 8;
        byArray[242] = 8;
        byArray[243] = 8;
        byArray[244] = 8;
        byArray[245] = 8;
        byArray[246] = 8;
        byArray[247] = 8;
        byArray[248] = 8;
        byArray[249] = 8;
        byArray[250] = 8;
        byArray[251] = 8;
        byArray[252] = 8;
        byArray[253] = 8;
        byArray[254] = 8;
        byArray[255] = 8;
        bitLen = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[3] = 2;
        byArray2[4] = 1;
        byArray2[5] = 2;
        byArray2[6] = 2;
        byArray2[7] = 3;
        byArray2[8] = 1;
        byArray2[9] = 2;
        byArray2[10] = 2;
        byArray2[11] = 3;
        byArray2[12] = 2;
        byArray2[13] = 3;
        byArray2[14] = 3;
        byArray2[15] = 4;
        byArray2[16] = 1;
        byArray2[17] = 2;
        byArray2[18] = 2;
        byArray2[19] = 3;
        byArray2[20] = 2;
        byArray2[21] = 3;
        byArray2[22] = 3;
        byArray2[23] = 4;
        byArray2[24] = 2;
        byArray2[25] = 3;
        byArray2[26] = 3;
        byArray2[27] = 4;
        byArray2[28] = 3;
        byArray2[29] = 4;
        byArray2[30] = 4;
        byArray2[31] = 5;
        byArray2[32] = 1;
        byArray2[33] = 2;
        byArray2[34] = 2;
        byArray2[35] = 3;
        byArray2[36] = 2;
        byArray2[37] = 3;
        byArray2[38] = 3;
        byArray2[39] = 4;
        byArray2[40] = 2;
        byArray2[41] = 3;
        byArray2[42] = 3;
        byArray2[43] = 4;
        byArray2[44] = 3;
        byArray2[45] = 4;
        byArray2[46] = 4;
        byArray2[47] = 5;
        byArray2[48] = 2;
        byArray2[49] = 3;
        byArray2[50] = 3;
        byArray2[51] = 4;
        byArray2[52] = 3;
        byArray2[53] = 4;
        byArray2[54] = 4;
        byArray2[55] = 5;
        byArray2[56] = 3;
        byArray2[57] = 4;
        byArray2[58] = 4;
        byArray2[59] = 5;
        byArray2[60] = 4;
        byArray2[61] = 5;
        byArray2[62] = 5;
        byArray2[63] = 6;
        byArray2[64] = 1;
        byArray2[65] = 2;
        byArray2[66] = 2;
        byArray2[67] = 3;
        byArray2[68] = 2;
        byArray2[69] = 3;
        byArray2[70] = 3;
        byArray2[71] = 4;
        byArray2[72] = 2;
        byArray2[73] = 3;
        byArray2[74] = 3;
        byArray2[75] = 4;
        byArray2[76] = 3;
        byArray2[77] = 4;
        byArray2[78] = 4;
        byArray2[79] = 5;
        byArray2[80] = 2;
        byArray2[81] = 3;
        byArray2[82] = 3;
        byArray2[83] = 4;
        byArray2[84] = 3;
        byArray2[85] = 4;
        byArray2[86] = 4;
        byArray2[87] = 5;
        byArray2[88] = 3;
        byArray2[89] = 4;
        byArray2[90] = 4;
        byArray2[91] = 5;
        byArray2[92] = 4;
        byArray2[93] = 5;
        byArray2[94] = 5;
        byArray2[95] = 6;
        byArray2[96] = 2;
        byArray2[97] = 3;
        byArray2[98] = 3;
        byArray2[99] = 4;
        byArray2[100] = 3;
        byArray2[101] = 4;
        byArray2[102] = 4;
        byArray2[103] = 5;
        byArray2[104] = 3;
        byArray2[105] = 4;
        byArray2[106] = 4;
        byArray2[107] = 5;
        byArray2[108] = 4;
        byArray2[109] = 5;
        byArray2[110] = 5;
        byArray2[111] = 6;
        byArray2[112] = 3;
        byArray2[113] = 4;
        byArray2[114] = 4;
        byArray2[115] = 5;
        byArray2[116] = 4;
        byArray2[117] = 5;
        byArray2[118] = 5;
        byArray2[119] = 6;
        byArray2[120] = 4;
        byArray2[121] = 5;
        byArray2[122] = 5;
        byArray2[123] = 6;
        byArray2[124] = 5;
        byArray2[125] = 6;
        byArray2[126] = 6;
        byArray2[127] = 7;
        byArray2[128] = 1;
        byArray2[129] = 2;
        byArray2[130] = 2;
        byArray2[131] = 3;
        byArray2[132] = 2;
        byArray2[133] = 3;
        byArray2[134] = 3;
        byArray2[135] = 4;
        byArray2[136] = 2;
        byArray2[137] = 3;
        byArray2[138] = 3;
        byArray2[139] = 4;
        byArray2[140] = 3;
        byArray2[141] = 4;
        byArray2[142] = 4;
        byArray2[143] = 5;
        byArray2[144] = 2;
        byArray2[145] = 3;
        byArray2[146] = 3;
        byArray2[147] = 4;
        byArray2[148] = 3;
        byArray2[149] = 4;
        byArray2[150] = 4;
        byArray2[151] = 5;
        byArray2[152] = 3;
        byArray2[153] = 4;
        byArray2[154] = 4;
        byArray2[155] = 5;
        byArray2[156] = 4;
        byArray2[157] = 5;
        byArray2[158] = 5;
        byArray2[159] = 6;
        byArray2[160] = 2;
        byArray2[161] = 3;
        byArray2[162] = 3;
        byArray2[163] = 4;
        byArray2[164] = 3;
        byArray2[165] = 4;
        byArray2[166] = 4;
        byArray2[167] = 5;
        byArray2[168] = 3;
        byArray2[169] = 4;
        byArray2[170] = 4;
        byArray2[171] = 5;
        byArray2[172] = 4;
        byArray2[173] = 5;
        byArray2[174] = 5;
        byArray2[175] = 6;
        byArray2[176] = 3;
        byArray2[177] = 4;
        byArray2[178] = 4;
        byArray2[179] = 5;
        byArray2[180] = 4;
        byArray2[181] = 5;
        byArray2[182] = 5;
        byArray2[183] = 6;
        byArray2[184] = 4;
        byArray2[185] = 5;
        byArray2[186] = 5;
        byArray2[187] = 6;
        byArray2[188] = 5;
        byArray2[189] = 6;
        byArray2[190] = 6;
        byArray2[191] = 7;
        byArray2[192] = 2;
        byArray2[193] = 3;
        byArray2[194] = 3;
        byArray2[195] = 4;
        byArray2[196] = 3;
        byArray2[197] = 4;
        byArray2[198] = 4;
        byArray2[199] = 5;
        byArray2[200] = 3;
        byArray2[201] = 4;
        byArray2[202] = 4;
        byArray2[203] = 5;
        byArray2[204] = 4;
        byArray2[205] = 5;
        byArray2[206] = 5;
        byArray2[207] = 6;
        byArray2[208] = 3;
        byArray2[209] = 4;
        byArray2[210] = 4;
        byArray2[211] = 5;
        byArray2[212] = 4;
        byArray2[213] = 5;
        byArray2[214] = 5;
        byArray2[215] = 6;
        byArray2[216] = 4;
        byArray2[217] = 5;
        byArray2[218] = 5;
        byArray2[219] = 6;
        byArray2[220] = 5;
        byArray2[221] = 6;
        byArray2[222] = 6;
        byArray2[223] = 7;
        byArray2[224] = 3;
        byArray2[225] = 4;
        byArray2[226] = 4;
        byArray2[227] = 5;
        byArray2[228] = 4;
        byArray2[229] = 5;
        byArray2[230] = 5;
        byArray2[231] = 6;
        byArray2[232] = 4;
        byArray2[233] = 5;
        byArray2[234] = 5;
        byArray2[235] = 6;
        byArray2[236] = 5;
        byArray2[237] = 6;
        byArray2[238] = 6;
        byArray2[239] = 7;
        byArray2[240] = 4;
        byArray2[241] = 5;
        byArray2[242] = 5;
        byArray2[243] = 6;
        byArray2[244] = 5;
        byArray2[245] = 6;
        byArray2[246] = 6;
        byArray2[247] = 7;
        byArray2[248] = 5;
        byArray2[249] = 6;
        byArray2[250] = 6;
        byArray2[251] = 7;
        byArray2[252] = 6;
        byArray2[253] = 7;
        byArray2[254] = 7;
        byArray2[255] = 8;
        bitCnt = byArray2;
        byte[] byArray3 = new byte[256];
        byArray3[0] = 8;
        byArray3[2] = 1;
        byArray3[4] = 2;
        byArray3[6] = 1;
        byArray3[8] = 3;
        byArray3[10] = 1;
        byArray3[12] = 2;
        byArray3[14] = 1;
        byArray3[16] = 4;
        byArray3[18] = 1;
        byArray3[20] = 2;
        byArray3[22] = 1;
        byArray3[24] = 3;
        byArray3[26] = 1;
        byArray3[28] = 2;
        byArray3[30] = 1;
        byArray3[32] = 5;
        byArray3[34] = 1;
        byArray3[36] = 2;
        byArray3[38] = 1;
        byArray3[40] = 3;
        byArray3[42] = 1;
        byArray3[44] = 2;
        byArray3[46] = 1;
        byArray3[48] = 4;
        byArray3[50] = 1;
        byArray3[52] = 2;
        byArray3[54] = 1;
        byArray3[56] = 3;
        byArray3[58] = 1;
        byArray3[60] = 2;
        byArray3[62] = 1;
        byArray3[64] = 6;
        byArray3[66] = 1;
        byArray3[68] = 2;
        byArray3[70] = 1;
        byArray3[72] = 3;
        byArray3[74] = 1;
        byArray3[76] = 2;
        byArray3[78] = 1;
        byArray3[80] = 4;
        byArray3[82] = 1;
        byArray3[84] = 2;
        byArray3[86] = 1;
        byArray3[88] = 3;
        byArray3[90] = 1;
        byArray3[92] = 2;
        byArray3[94] = 1;
        byArray3[96] = 5;
        byArray3[98] = 1;
        byArray3[100] = 2;
        byArray3[102] = 1;
        byArray3[104] = 3;
        byArray3[106] = 1;
        byArray3[108] = 2;
        byArray3[110] = 1;
        byArray3[112] = 4;
        byArray3[114] = 1;
        byArray3[116] = 2;
        byArray3[118] = 1;
        byArray3[120] = 3;
        byArray3[122] = 1;
        byArray3[124] = 2;
        byArray3[126] = 1;
        byArray3[128] = 7;
        byArray3[130] = 1;
        byArray3[132] = 2;
        byArray3[134] = 1;
        byArray3[136] = 3;
        byArray3[138] = 1;
        byArray3[140] = 2;
        byArray3[142] = 1;
        byArray3[144] = 4;
        byArray3[146] = 1;
        byArray3[148] = 2;
        byArray3[150] = 1;
        byArray3[152] = 3;
        byArray3[154] = 1;
        byArray3[156] = 2;
        byArray3[158] = 1;
        byArray3[160] = 5;
        byArray3[162] = 1;
        byArray3[164] = 2;
        byArray3[166] = 1;
        byArray3[168] = 3;
        byArray3[170] = 1;
        byArray3[172] = 2;
        byArray3[174] = 1;
        byArray3[176] = 4;
        byArray3[178] = 1;
        byArray3[180] = 2;
        byArray3[182] = 1;
        byArray3[184] = 3;
        byArray3[186] = 1;
        byArray3[188] = 2;
        byArray3[190] = 1;
        byArray3[192] = 6;
        byArray3[194] = 1;
        byArray3[196] = 2;
        byArray3[198] = 1;
        byArray3[200] = 3;
        byArray3[202] = 1;
        byArray3[204] = 2;
        byArray3[206] = 1;
        byArray3[208] = 4;
        byArray3[210] = 1;
        byArray3[212] = 2;
        byArray3[214] = 1;
        byArray3[216] = 3;
        byArray3[218] = 1;
        byArray3[220] = 2;
        byArray3[222] = 1;
        byArray3[224] = 5;
        byArray3[226] = 1;
        byArray3[228] = 2;
        byArray3[230] = 1;
        byArray3[232] = 3;
        byArray3[234] = 1;
        byArray3[236] = 2;
        byArray3[238] = 1;
        byArray3[240] = 4;
        byArray3[242] = 1;
        byArray3[244] = 2;
        byArray3[246] = 1;
        byArray3[248] = 3;
        byArray3[250] = 1;
        byArray3[252] = 2;
        byArray3[254] = 1;
        trailingZeroCnt = byArray3;
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        n = 0;
        while (n < 63) {
            BigInteger.zeros[n] = zeros[63].substring(0, n);
            ++n;
        }
        System.loadLibrary("math");
        BigInteger.plumbInit();
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        ZERO_CHAR = Character.forDigit(0, 2);
        int[] nArray = new int[37];
        nArray[2] = 62;
        nArray[3] = 39;
        nArray[4] = 31;
        nArray[5] = 27;
        nArray[6] = 24;
        nArray[7] = 22;
        nArray[8] = 20;
        nArray[9] = 19;
        nArray[10] = 18;
        nArray[11] = 18;
        nArray[12] = 17;
        nArray[13] = 17;
        nArray[14] = 16;
        nArray[15] = 16;
        nArray[16] = 15;
        nArray[17] = 15;
        nArray[18] = 15;
        nArray[19] = 14;
        nArray[20] = 14;
        nArray[21] = 14;
        nArray[22] = 14;
        nArray[23] = 13;
        nArray[24] = 13;
        nArray[25] = 13;
        nArray[26] = 13;
        nArray[27] = 13;
        nArray[28] = 13;
        nArray[29] = 12;
        nArray[30] = 12;
        nArray[31] = 12;
        nArray[32] = 12;
        nArray[33] = 12;
        nArray[34] = 12;
        nArray[35] = 12;
        nArray[36] = 12;
        digitsPerLong = nArray;
        longRadix = new BigInteger[]{null, null, BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(0x4000000000000000L), BigInteger.valueOf(7450580596923828125L), BigInteger.valueOf(4738381338321616896L), BigInteger.valueOf(3909821048582988049L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1350851717672992089L), BigInteger.valueOf(1000000000000000000L), BigInteger.valueOf(5559917313492231481L), BigInteger.valueOf(2218611106740436992L), BigInteger.valueOf(8650415919381337933L), BigInteger.valueOf(2177953337809371136L), BigInteger.valueOf(6568408355712890625L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(2862423051509815793L), BigInteger.valueOf(6746640616477458432L), BigInteger.valueOf(799006685782884121L), BigInteger.valueOf(1638400000000000000L), BigInteger.valueOf(3243919932521508681L), BigInteger.valueOf(6221821273427820544L), BigInteger.valueOf(504036361936467383L), BigInteger.valueOf(876488338465357824L), BigInteger.valueOf(1490116119384765625L), BigInteger.valueOf(2481152873203736576L), BigInteger.valueOf(4052555153018976267L), BigInteger.valueOf(6502111422497947648L), BigInteger.valueOf(353814783205469041L), BigInteger.valueOf(531441000000000000L), BigInteger.valueOf(787662783788549761L), BigInteger.valueOf(0x1000000000000000L), BigInteger.valueOf(1667889514952984961L), BigInteger.valueOf(2386420683693101056L), BigInteger.valueOf(3379220508056640625L), BigInteger.valueOf(4738381338321616896L)};
    }
}

